(*
Speak Sender and Subject

Copyright © 2003–2013 Apple Inc. All rights reserved.

You may incorporate this Apple sample code into your program(s) without
restriction.  This Apple sample code has been provided "AS IS" and the
responsibility for its operation is yours.  You are not permitted to
redistribute this Apple sample code as "Apple sample code" after having
made changes.  If you're going to redistribute the code, we require that
you make it clear that the code was descended from Apple sample code,
but that you've made changes.
*)

(*
This script speaks the sender and subject of each selected message.
*)

tell application "Mail"
	set selectedMessages to selection
	
	set selectionCount to (count of selectedMessages)
	if selectionCount is greater than 1 then
		set speakString to "There are " & selectionCount & " selected messages." & return
	else if selectionCount is equal to 1 then
		set speakString to "There is " & selectionCount & " selected message." & return
	else -- selectionCount is less than or equal to 0
		set speakString to "There are no selected messages."
	end if
	
	repeat with messageNumber from 1 to selectionCount
		set theMessage to item messageNumber of selectedMessages
		set theSubject to subject of theMessage
		set theSender to extract name from (sender of theMessage)
		set speakString to speakString & "Message " & (messageNumber as string) & " From: " & theSender & ", Subject: " & theSubject & ".  " & return
	end repeat
end tell
say speakString